// Ionic Starter App

// angular.module is a global place for creating, registering and retrieving Angular modules
// 'starter' is the name of this angular module example (also set in a <body> attribute in index.html)
// the 2nd parameter is an array of 'requires'
angular.module('starter', ['ionic', 'ngCordova', 'pascalprecht.translate', 'uiGmapgoogle-maps', 'nemLogging', 'starter.main', 'starter.schedules', 'starter.info', 'starter.nearest', 'starter.goto'])

	.run(function($ionicPlatform,$state,$ionicHistory,$ionicPopup,$ionicConfig) {
	  $ionicPlatform.ready(function() {
		
		if(window.cordova && window.cordova.plugins.Keyboard) {
		  // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
		  // for form inputs)
		  cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);

		  // Don't remove this line unless you know what you are doing. It stops the viewport
		  // from snapping when text inputs are focused. Ionic handles this internally for
		  // a much nicer keyboard experience.
		  cordova.plugins.Keyboard.disableScroll(true);
		}
		
		if(window.StatusBar) {
		  StatusBar.styleDefault();
		}
		
		$ionicConfig.views.maxCache(0);
		
		//Register Back Action
		
		$ionicPlatform.registerBackButtonAction(function(event) {
		    
			event.preventDefault();
			
		    if ($state.current.name == "app.main") {
				
		        var confirmPopup = $ionicPopup.confirm({
		            title: 'Exit ?',
		        });

		        confirmPopup.then(function(res) {
		            if (res)
		                navigator.app.exitApp();

		        });
		    }
			else
			{
				//Make sure loading is hidden
				
				$ionicLoading.hide();
				
				//Go Back
				
				$ionicHistory.goBack();
			}
				
			
		}, 800); 
	  
	  });
	})

    .config(function ($stateProvider, $urlRouterProvider, $translateProvider, uiGmapGoogleMapApiProvider) {

		//Routes
	
		$stateProvider.state('app', {
			url: "/app",
			abstract: true,
			templateUrl: "templates/layout.html",
			controller: 'AppCtrl'
		})

        // if none of the above states are matched, use this as the fallback
        $urlRouterProvider.otherwise('/app/main');
		
		//Google maps
		
		uiGmapGoogleMapApiProvider.configure({
			key: 'AIzaSyCT0_DDA0CGGLRlkx5DPRIR6pzhW-wjd0Y',
			language: 'en',
		})
		
		//Languages
		
		$translateProvider.translations('en', {
			
			flag: "en",
			language: "Language",
			
			language_popover_title: "Change Language",
			language_popover_change: "Select language",
			language_popover_native_en: "English",
			language_popover_native_pt: "Portuguese",
			
            menu__left_title: "Menu",
			menu__left_dashboard: "Home",
			menu__left_schedules: "Schedules",
            menu__left_go_to: "Go To",
			menu__left_nearest_stops: "Nearest Stops",
            menu__left_usefull_info: "Usefull Info",
			menu__left_close: "Exit",
			menu__left_back: "Go Back",
			
			footer_title: "SRTU - Urban Transportation Tracking System",
			footer_title_small: "SRTU",
			
			misc_go: "Go",
			
			search_main : "Select a route",
			
			usefull_info_main : "Usefull Informations",
			
			main_title : "Welcome!",
			main_subtitle : "Navigate through the options below:",
			
			loading_msg : "Loading content,<br>please wait...",
			
			schedulesList_tableHeader_Destination : "Destination",
			schedulesList_tableHeader_Next : "Next",
			schedulesList_tableHeader_Actions : "Actions",
			schedulesList_btn_AllSchedules : "View All",
			schedulesList_btn_ToggleSchedules : "Invert Course",
			schedulesList_btn_ViewAllTable : "View All Schedules",
			schedulesList_btn_BusLocation : "View Bus Location",
			
			schedulesList_tableHeader_Schedule : "Schedule",
			schedulesList_tableHeader_Timeleft : "Next Passage",
			
			btn_back : "Back",
			btn_update : "Update",
			btn_actions : "Actions",
			
			time_days : "Day(s)",
			time_hours : "Hour(s)",
			time_minutes : "Minute(s)",
			
			nearest_dist : "Distance",
			nearest_lines : "Route",
			nearest_color : "Color",
			nearest_direction : "Direction",
			nearest_time : "Time",
			nearest_timeleft : "Time Left",
			nearest_nextStops : "Next Bus",
			nearest_viewLine : "View Route Schedules",
			nearest_viewMap : "View on the Map",
			
			goto_near : "Nearest stop from your Location",
			goto_dist : "Distance from stop to your destination",
			goto_lines : "Route to take",
			goto_color : "Route Color",
			goto_direction : "Direction",
			goto_time : "Time",
			goto_timeleft : "Time Left",
			goto_nextStops : "Next Bus",
			goto_viewLine : "View Route Schedules",
			goto_viewMap : "View on the Map",
			goto_destiny : "Destination",
			
			goto_main : "Provide the location the system will return the closest stop and route number.",
			goto_search_term : "Enter a location...",
			goto_search : "Search",
			goto_destination : "Destination",
			goto_location : "Search Nearest Stop",
			goto_noresults : "No results",
			
			map_my_position : "Your are here!",
			map_bus_position : "BUS",
			
        });
        $translateProvider.translations('pt', {
			
			flag: "pt",
			language: "Idioma",
			
			language_popover_title: "Mudar Idioma",
			language_popover_change: "Seleccione o idioma",
			language_popover_native_en: "Ingles",
			language_popover_native_pt: "Portugues",
			
			menu__left_title: "Menu",
			menu__left_dashboard: "Inicio",
            menu__left_schedules: "Horários",
            menu__left_go_to: "Ir Para",
			menu__left_nearest_stops: "Paragens Mais Próximas",
            menu__left_usefull_info: "Informações Uteis",
			menu__left_close: "Fechar Aplicação",
			menu__left_back: "Voltar",
			
			footer_title: "SRTU - Sistema de Rastreio de Transportes Urbanos",
			footer_title_small: "SRTU",
			
			misc_go: "Ir",
			
			search_main : "Selecione uma das linhas",
			
			usefull_info_main : "Informações Uteis",
			
			main_title : "Bem vindo!",
			main_subtitle : "Selecione uma das opções para navegar:",
			
			loading_msg : "A carregar conteúdo,<br>por favor aguarde...",
			
			schedulesList_tableHeader_Destination : "Destino",
			schedulesList_tableHeader_Next : "Seguinte",
			schedulesList_tableHeader_Actions : "Acções",
			schedulesList_btn_AllSchedules : "Ver Todos",
			schedulesList_btn_ToggleSchedules : "Inverter Percurso",
			schedulesList_btn_ViewAllTable : "Ver Todos os Horários",
			schedulesList_btn_BusLocation : "Ver Localização do Autocarro",
			
			schedulesList_tableHeader_Schedule : "Horário",
			schedulesList_tableHeader_Timeleft : "Proxima Passagem",
			
			btn_back : "Voltar",
			btn_update : "Actualizar",
			btn_actions : "Acções",
			
			time_days : "Dia(s)",
			time_hours : "Hora(s)",
			time_minutes : "Minuto(s)",
			
			goto_near : "Paragem Mais Próxima",
			nearest_dist : "Distancia",
			nearest_lines : "Linha",
			nearest_color : "Cor",
			nearest_direction : "Direcção",
			nearest_time : "Hora",
			nearest_timeleft : "Tempo Restante",
			nearest_nextStops : "Próximas Passagens",
			nearest_viewLine : "Ver Horários da Linha",
			nearest_viewMap : "Ver no Mapa",
			
			goto_dist : "Distância da paragem ao seu destino",
			goto_lines : "Linha a apanhar",
			goto_color : "Cor",
			goto_direction : "Direcção",
			goto_time : "Hora",
			goto_timeleft : "Tempo Restante",
			goto_nextStops : "Próximas Passagens",
			goto_viewLine : "Ver Horários da Linha",
			goto_viewMap : "Ver no Mapa",
			goto_destiny : "Destino",
			
			goto_main : "Insira a localização, o sistema irá devolver a paragem mais próxima e a linha correspondente. ",
			goto_search_term : "Insira uma localização e a cidade...",
			goto_search : "Pesquisar",
			goto_destination : "Destino / Localização",
			goto_location : "Procurar Paragem Mais Próxima",
			goto_noresults : "Sem resultados",
			
			map_my_position : "Voce está aqui!",
			map_bus_position : "Autocarro",
			
        });
		
        $translateProvider.preferredLanguage("pt");
        $translateProvider.fallbackLanguage("en");
		
    })

    .controller('AppCtrl', function ($scope, $ionicModal, $ionicPopover, $timeout, $ionicLoading, $location, $translate) {
		
		//Language functions

		$scope.changeLanguage = function (key) {
			$translate.use(key);
			$scope.popover.hide();
		};
		
		$ionicPopover.fromTemplateUrl('templates/language_popover.html', {
			scope: $scope
		}).then(function(popover) {
			$scope.popover = popover;
		});

		$scope.openPopover = function($event) {
			$scope.popover.show($event);
		};
		$scope.closePopover = function() {
			$scope.popover.hide();
		};
		
		//Technical Info
		
		$ionicModal.fromTemplateUrl('templates/technical_info.html', {
			scope: $scope,
			animation: 'slide-in-up'
		}).then(function(modal) {
			$scope.technicalInfo = modal;
		});
		$scope.showTechnicalInfo = function() {
			$scope.technicalInfo.show();
		};
		$scope.closeTechnicalInfo = function() {
			$scope.technicalInfo.hide();
		};
  
        // Form data for the login modal
		
		$scope.pageProperties = new Object();
		$scope.pageProperties.pageName = $translate.instant('menu__left_dashboard');
		
        $scope.loginData = {};
		
		$scope.jsonError = false;
		
		$scope.go = function ( path ) {
			$location.path( path );
		};
		
		$scope.showLoader = function() {
			$ionicLoading.show({
				template: $translate.instant('loading_msg')
			});
		};
		
		$scope.hideLoader = function(){
			$ionicLoading.hide();
		};
		
		$scope.isLandscape = function(){
			return screen.orientation.type.indexOf('landscape') !== -1;
		};
		
		$scope.exitApp = function(){
			navigator.app.exitApp();
		}
		
    });
