angular.module('starter.goto', [])

    .config(function ($stateProvider) {

		$stateProvider
	
            .state('app.goto', {
                url: "/goto",
                views: {
                    'pageContent': {
                        templateUrl: "templates/goto.html",
                        controller: "gotoCtrl"
                    }
                }
            })
			
			.state('app.gotoResult', {
                url: "/gotoResult/:lat/:lon/:destination",
                views: {
                    'pageContent': {
                        templateUrl: "templates/gotoResult.html",
                        controller: "gotoResultCtrl"
                    }
                }
            })
			
    })

    .controller('gotoCtrl', function ($scope, $http, $stateParams, $translate) {
		
		// Set page name
		
		$scope.pageProperties.pageName = $translate.instant('menu__left_go_to');
		
		//Init
		
		$scope.init = function () {

			$scope.queryParams = new Object();
			
		}
		
		$scope.lookupLocations = function(){
			
			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/getAddressCoordinates/'+encodeURI($scope.queryParams.location)+'.json'
			}).then(function successCallback(response) {
				
				$scope.locations = response.data.data.results;
				
			});
			
		}
		
		$scope.init();

    })
	
	.controller('gotoResultCtrl', function ($scope, $http, $stateParams, $translate) {
		
		// Set page name
		
		$scope.pageProperties.pageName = $translate.instant('menu__left_go_to');
		
		//Init
		
		$scope.init = function () {

			//Show loader
			
			$scope.showLoader();
		
			//Init
			
			$scope.destination = $stateParams.destination;
			
			$scope.lookupLocations();
			
		}
		
		$scope.lookupLocations = function(){
			
			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/nearestArrivals/'+$stateParams.lat+'/'+$stateParams.lon+'.json'
			}).then(function successCallback(response) {

				//Update model

				$scope.nearestInfo = response.data.data.results;

				//Hide loader
				
				$scope.hideLoader();
				
				
			});
			
		}
		
		$scope.dealWithTime = function (time) {
			
			var time = time;
			
			time = time.replace('[days]', $translate.instant('time_days'));
			time = time.replace('[hours]', $translate.instant('time_hours'));
			time = time.replace('[minutes]', $translate.instant('time_minutes'));
			
			return time;
			
		}
		
		$scope.init();

    });