angular.module('starter.nearest', [])

    .config(function ($stateProvider) {

		$stateProvider
	
            .state('app.nearest', {
                url: "/nearest",
                views: {
                    'pageContent': {
                        templateUrl: "templates/nearest.html",
                        controller: "nearestCtrl"
                    }
                }
            })
			
			.state('app.nearestMap', {
                url: "/nearestMap/:stopId",
                views: {
                    'pageContent': {
                        templateUrl: "templates/nearestMap.html",
                        controller: "nearestMapCtrl"
                    }
                }
            });
    })

    .controller('nearestCtrl', function ($scope, $http, $stateParams, $cordovaGeolocation, $translate, $timeout) {
		
		// Set page name
		
		$scope.pageProperties.pageName = $translate.instant('menu__left_nearest_stops');
		
		//Init
		
		$scope.init = function () {
			
			//Show loader
			
			$scope.showLoader();

			//Declare user pos
			
			$scope.curPos = {
				lat : 0,
				lon : 0
			};
			
			//Init geolocation plugin
			
			var watchOptions = {
				timeout : 3000,
				enableHighAccuracy: true // may cause errors if true
			};

			var watch = $cordovaGeolocation.watchPosition(watchOptions);
			
			watch.then(null, function(err) {},
				function(position) {
					
					$scope.curPos.lat  = position.coords.latitude
					$scope.curPos.lon = position.coords.longitude
					
				}
			);
			
			//Call get info
			
			$scope.getInfo();

		}
		
		$scope.getInfo = function(){
			
			//Return in a bit in case we still dont have coords
			
			if($scope.curPos.lat==0)
			{
				$timeout($scope.getInfo,1000);
				return;
			}
		
			//Get request

			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/nearestArrivals/'+$scope.curPos.lat+'/'+$scope.curPos.lon+'.json'
			}).then(function successCallback(response) {

				//Update model

				$scope.nearestInfo = response.data.data.results;

				//Hide loader
				
				$scope.hideLoader();
				
				
			});
			
		}
		
		$scope.dealWithTime = function (time) {
			
			var time = time;
			
			time = time.replace('[days]', $translate.instant('time_days'));
			time = time.replace('[hours]', $translate.instant('time_hours'));
			time = time.replace('[minutes]', $translate.instant('time_minutes'));
			
			return time;
			
		}
		
		$scope.init();

    })
	
	.controller('nearestMapCtrl', function ($scope, $http, $stateParams, $cordovaGeolocation, $translate, uiGmapGoogleMapApi, uiGmapIsReady, $timeout, $rootScope) {

		//Google Maps
	
		uiGmapIsReady.promise().then(function (maps) {

			//Can initializer after map is loaded
			
			$scope.mapInstance = maps[0].map;
			
			//Load markers
		
			$scope.loadMarkers();
			
		});
		
		// Set page name
		
		$scope.pageProperties.pageName = $translate.instant('menu__left_nearest_stops');
		
		//Set default
		
		$scope.map = { center: { latitude: '37.138287', longitude: '-8.537579' }, zoom: 10, control : {} };
		
		//Init
		
		$scope.init = function () {
			
			//Show loader
			
			$scope.showLoader();
			
			//Init markers list
	
			$scope.markersList = new Array();
			$scope.stopsList = new Object();
			
			$scope.curPos = {
				lat : 0,
				lon : 0
			};
			
			$scope.vehiclePos = {
				lat : 0,
				lon : 0
			};
			
			//Init geolocation plugin
			
			var watchOptions = {
				timeout : 3000,
				enableHighAccuracy: true // may cause errors if true
			};

			var watch = $cordovaGeolocation.watchPosition(watchOptions);
			
			watch.then(null, function(err) {},
				function(position) {
					
					$scope.curPos.lat  = position.coords.latitude
					$scope.curPos.lon = position.coords.longitude
					
				}
			);
			
			$scope.updateTracker = {
				instance : null
			}
			
			$scope.gpsPositions = {
				instance : null
			}
			
			var dereg = $rootScope.$on('$locationChangeSuccess', function() {
				$timeout.cancel($scope.updateTracker.instance);
				$timeout.cancel($scope.gpsPositions.instance);
				dereg();
			});
			
			//Grab Gps coords
			
			$scope.getGPSPositions();
			
			//Update positions
			
			$scope.updatePositions();

		}
		
		$scope.loadMarkers = function(){
			
			//Init info windows
			
			var infowindow = new google.maps.InfoWindow();
			
			$scope.map.markersEvents = {
				click: function(marker, eventName, model, args) {

					infowindow.setContent($scope.stopsList[marker.key].location);
					infowindow.open($scope.mapInstance, marker);      
				},
			};
		
			//Get request

			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/stopCoordinates/'+$stateParams.stopId+'.json'
			}).then(function successCallback(response) {

				//Update model

				$scope.coordsInfo = response.data.data.results;

				//Add user marker
				
				var vehicleMarker = {
					latitude: $scope.vehiclePos.lat,
					longitude: $scope.vehiclePos.lon,
					title: 'BUS',
					icon: 'http://cp.srtu.pt/img/marker_vehicle.png',
					id:'vehicleMarker'
				};
	  
				$scope.markersList.push(vehicleMarker);
				
				$scope.stopsList.vehicleMarker = {
					location : $translate.instant('map_bus_position')
				};
				
				//Add vehicle marker
			
				var userMarker = {
					latitude: $scope.curPos.lat,
					longitude: $scope.curPos.lon,
					title: 'You',
					icon: 'http://cp.srtu.pt/img/my_location.png',
					id:'userMarker'
				};
	  
				$scope.markersList.push(userMarker);
				
				$scope.stopsList.userMarker = {
					location : $translate.instant('map_my_position')
				};
				
				//Add stop marker
				
				var stopMarker = {
					latitude: $scope.coordsInfo.lat,
					longitude: $scope.coordsInfo.lon,
					title: stop.location,
					icon: 'http://cp.srtu.pt/img/marker_blue.png',
					id:'stopMarker'
				};
	  
				$scope.markersList.push(stopMarker);
				
				$scope.stopsList.stopMarker = {
					location : '# - '+$scope.coordsInfo.location,
				};
				
				//Center map
				
				$scope.map.zoom = 15;
				$scope.map.center.latitude = $scope.coordsInfo.lat;
				$scope.map.center.longitude = $scope.coordsInfo.lon;

				//Mark path in between

				// instantiate google map objects for directions
				var directionsDisplay = new google.maps.DirectionsRenderer();
				var directionsService = new google.maps.DirectionsService();

				// get directions using google maps api

				var request = {
					origin: new google.maps.LatLng($scope.curPos.lat, $scope.curPos.lon),
					destination: new google.maps.LatLng($scope.coordsInfo.lat, $scope.coordsInfo.lon),
					travelMode: google.maps.DirectionsTravelMode.DRIVING,
				};
				
				directionsService.route(request, function (response, status) {
				  
					if (status === google.maps.DirectionsStatus.OK) {

						directionsDisplay.setDirections(response);
						directionsDisplay.setOptions( { suppressMarkers: true } );
						directionsDisplay.setMap($scope.map.control.getGMap());

					}
					
				  
				});
				
				//Hide loader
				
				$scope.hideLoader();
				
			});
			
		}
		
		$scope.getGPSPositions = function(){
			
			//Pull from geolocation plugin
			
			var watchOptions = {
				timeout : 3000,
				enableHighAccuracy: true // may cause errors if true
			};

			var watch = $cordovaGeolocation.watchPosition(watchOptions);
			
			watch.then(null, 
				function(err) {
					
					//Recall anyway
					
					$scope.gpsPositions.instance = $timeout($scope.getGPSPositions, 5000);
					
				},
				function(position) {
				
					$scope.curPos.lat  = position.coords.latitude
					$scope.curPos.lon = position.coords.longitude
					
					//Recall
					
					$scope.gpsPositions.instance = $timeout($scope.getGPSPositions, 5000);
					
				}
			);
			
		}
		
		$scope.updatePositions = function(){
			
			//Call position
			
			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/getLineCoordinates/'+$stateParams.stopId+'.json'
			}).then(function successCallback(response) {
				
				if(response.data.data.results.id_vehicle === undefined)
					return;
				
				response = response.data.data.results;
				
				//Set vehicle POS
				
				$scope.vehiclePos.lat = response.lat;
				$scope.vehiclePos.lon = response.lon;
				
				try{
										
					//Update vehicle POS
					
					$scope.markersList[0].latitude = $scope.vehiclePos.lat;
					$scope.markersList[0].longitude = $scope.vehiclePos.lon;
					
					//Update user POS
				
					$scope.markersList[1].latitude = $scope.curPos.lat;
					$scope.markersList[1].longitude = $scope.curPos.lon;
				
				}
				catch(ex){};

				$scope.updateTracker.instance = $timeout($scope.updatePositions, 5000);
				
			});

			
		}
		
		$scope.init();

    });