angular.module('starter.schedules', [])

    .config(function ($stateProvider) {

		$stateProvider
	
            .state('app.schedules', {
                url: "/schedules",
                views: {
                    'pageContent': {
                        templateUrl: "templates/schedules.html",
                        controller: "schedulesCtrl"
                    }
                }
            })
			
			.state('app.schedulesList', {
                url: "/schedulesList/:routeId",
                views: {
                    'pageContent': {
                        templateUrl: "templates/schedulesList.html",
                        controller: "schedulesListCtrl"
                    }
                }
            })
		
			.state('app.schedulesViewAll', {
                url: "/schedulesViewAll/:routeId",
                views: {
                    'pageContent': {
                        templateUrl: "templates/schedulesViewAll.html",
                        controller: "schedulesViewAllCtrl"
                    }
                }
            })
						
			.state('app.schedulesViewStop', {
                url: "/schedulesViewStop/:stopId",
                views: {
                    'pageContent': {
                        templateUrl: "templates/schedulesViewStop.html",
                        controller: "schedulesViewStopCtrl"
                    }
                }
            })
			
			.state('app.schedulesMap', {
                url: "/schedulesMap/:routeId",
                views: {
                    'pageContent': {
                        templateUrl: "templates/schedulesMap.html",
                        controller: "schedulesMapCtrl"
                    }
                }
            });
    })

    .controller('schedulesCtrl', function ($scope, $http, $stateParams, $cordovaGeolocation, uiGmapGoogleMapApi, $translate) {
		
		// Set page name
		
		$scope.pageProperties.pageName = $translate.instant('menu__left_schedules');
		
		//Init routes
		
		$scope.routes = new Array();
		
		$scope.getRoutes = function () {

			//Show loader
			
			$scope.showLoader();
		
			//Get request

			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/routes.json'
			}).then(function successCallback(response) {

				//Update model

				$scope.routes = response.data.data.results;

				//Hide loader
				
				$scope.hideLoader();
				
				
			});

		}
		
		$scope.getRoutes();

    })
	
	.controller('schedulesListCtrl', function ($scope, $http, $stateParams, $cordovaGeolocation, uiGmapGoogleMapApi, $translate) {
		
		// Set page name
		
		$scope.pageProperties.pageName = $translate.instant('menu__left_schedules');
		
		//Set route ids
		
		$scope.routeId = $stateParams.routeId;
		
		//Init routes
		
		$scope.schedules = new Array();
		
		$scope.getSchedules = function () {

			//Show loader
			
			$scope.showLoader();
		
			//Get request

			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/schedules/'+$stateParams.routeId+'.json'
			}).then(function successCallback(response) {

				//Update model

				$scope.schedulesInfo = response.data.data.results.info;
				$scope.schedules = response.data.data.results.schedules;

				//Hide loader
				
				$scope.hideLoader();
				
				
			});

		}
		
		$scope.getSchedules();

    })
	
	.controller('schedulesViewAllCtrl', function ($scope, $http, $stateParams, $cordovaGeolocation, uiGmapGoogleMapApi, $translate) {

		$scope.init = function(){
			
			//Set route ids
		
			$scope.routeId = $stateParams.routeId;
			
			//Init routes
			
			$scope.schedules = new Array();
			
			//Set column
			
			$scope.column = 0;
			
			//Get schedules
		
			$scope.getSchedules();
			
		}
		
		$scope.getSchedules = function () {

			//Show loader
			
			$scope.showLoader();
		
			//Get request

			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/schedulesAll/'+$stateParams.routeId+'.json'
			}).then(function successCallback(response) {

				//Update model

				$scope.schedules = response.data.data.results;

				//Hide loader
				
				$scope.hideLoader();
				
				
			});

		}
		
		$scope.renderColumn = function(direction, length){

			if(direction == 'next' && $scope.column + 1 < length)
				$scope.column++;
			
			if(direction == 'previous' && $scope.column - 1 > 0)
				$scope.column--;
			
		}
		
		$scope.init();

    })
	
	.controller('schedulesViewStopCtrl', function ($scope, $http, $stateParams, $cordovaGeolocation, uiGmapGoogleMapApi, $translate) {
		
		// Set page name
		
		$scope.pageProperties.pageName = $translate.instant('menu__left_schedules');
		
		//Set route ids
		
		$scope.routeId = $stateParams.routeId;
		
		//Init routes
		
		$scope.schedules = new Array();
		
		$scope.getSchedules = function () {

			//Show loader
			
			$scope.showLoader();
		
			//Get request

			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/schedulesItem/'+$stateParams.stopId+'.json'
			}).then(function successCallback(response) {

				//Update model

				$scope.schedulesInfo = response.data.data.results.info;
				$scope.schedules = response.data.data.results.schedules;

				//Hide loader
				
				$scope.hideLoader();
				
				
			});

		}
		
		$scope.dealWithTime = function (time) {
			
			var time = time;
			
			time = time.replace('[days]', $translate.instant('time_days'));
			time = time.replace('[hours]', $translate.instant('time_hours'));
			time = time.replace('[minutes]', $translate.instant('time_minutes'));
			
			return time;
			
		}
		
		$scope.getSchedules();

    })
	
	.controller('schedulesMapCtrl', function ($scope, $http, $stateParams, $cordovaGeolocation, $translate, uiGmapGoogleMapApi, uiGmapIsReady, $timeout, $rootScope) {
		
		//Google Maps
	
		uiGmapIsReady.promise().then(function (maps) {

			//Can initializer after map is loaded
		
			$scope.mapInstance = maps[0].map;
			
			$scope.loadMarkers();
			
		});
		
		//Set default
		
		$scope.map = { center: { latitude: '37.138287', longitude: '-8.537579' }, zoom: 10, control : {} };
		
		//Init
		
		$scope.init = function () {
			
			if(typeof $scope.initialized !== 'undefined')
				return;
			
			$scope.initialized = true;
			
			//Show loader
			
			$scope.showLoader();
			
			//Init vars
	
			$scope.markersList = new Array();
			$scope.stopsList = new Object();
			
			$scope.curPos = {
				lat : 0,
				lon : 0
			};
			
			$scope.vehiclePos = {
				lat : 0,
				lon : 0
			};
			
			$scope.updateTracker = {
				first : true,
				running : false,
				instance : null
			};
			
			$scope.gpsPositions = {
				instance : null
			}
			
			var dereg = $rootScope.$on('$locationChangeSuccess', function() {
				$timeout.cancel($scope.updateTracker.instance);
				$timeout.cancel($scope.gpsPositions.instance);
				dereg();
			});
			
			//Grab Gps coords
			
			$scope.getGPSPositions();
			
			//Update positions
			
			$scope.updatePositions();

		}
		
		$scope.loadMarkers = function(){

			//Init info windows
			
			var infowindow = new google.maps.InfoWindow();
			
			$scope.map.markersEvents = {
				click: function(marker, eventName, model, args) {

					infowindow.setContent($scope.stopsList[marker.key].location);
					infowindow.open($scope.mapInstance, marker);      
				},
			};
			
			//Call position
			
			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/getLineStops/'+$stateParams.routeId+'.json'
			}).then(function successCallback(response) {
				
				response = response.data.data.results;
				
				$scope.markersList = new Array();
				
				//Add user marker
			
				var userMarker = {
					latitude: $scope.curPos.lat,
					longitude: $scope.curPos.lon,
					title: 'You',
					icon: 'http://cp.srtu.pt/img/my_location.png',
					id: 'userMarker'
				};
	  
				$scope.markersList.push(userMarker);
				
				$scope.stopsList.userMarker = {
					location : $translate.instant('map_my_position')
				};
				
				//Add Vehicle Marker
				
				var vehicleMarker = {
					latitude: $scope.vehiclePos.lat,
					longitude: $scope.vehiclePos.lon,
					title: 'BUS',
					icon: 'http://cp.srtu.pt/img/marker_vehicle.png',
					id:'vehicleMarker'
				};
	  
				$scope.markersList.push(vehicleMarker);
				
				$scope.stopsList.vehicleMarker = {
					location : $translate.instant('map_bus_position')
				};
				
				//Centering Map
					
				$scope.map.zoom = 15;
				$scope.map.center.latitude = $scope.vehiclePos.lat;
				$scope.map.center.longitude = $scope.vehiclePos.lon;
				
				//Add stops markers

				angular.forEach(response, function(stop, key) {
									
					var stopMarker = {
						latitude: stop.lat,
						longitude: stop.lon,
						title: stop.location,
						icon: 'http://cp.srtu.pt/img/marker_blue.png',
						id: 'stop_'+key
					};		
		  
					$scope.markersList.push(stopMarker);
					
					$scope.stopsList[stopMarker.id] = {
						location : '#'+(key+1)+' - '+stopMarker.title,
					};
				
				});

				//Hide loader
		
				$scope.hideLoader();
				
			});
			
		}
		
		$scope.getGPSPositions = function(){
			
			//Pull from geolocation plugin
			
			var watchOptions = {
				timeout : 3000,
				enableHighAccuracy: true // may cause errors if true
			};

			var watch = $cordovaGeolocation.watchPosition(watchOptions);
			
			watch.then(null, 
				function(err) {
					
					//Recall anyway
					
					$scope.gpsPositions.instance = $timeout($scope.getGPSPositions, 5000);
					
				},
				function(position) {
				
					$scope.curPos.lat  = position.coords.latitude
					$scope.curPos.lon = position.coords.longitude
					
					//Recall
					
					$scope.gpsPositions.instance = $timeout($scope.getGPSPositions, 5000);
					
				}
			);
			
		}
		
		$scope.updatePositions = function(){
			
			//Call position
			
			$http({
				method: 'GET',
				url: 'http://api.srtu.pt/handler/get/getLineCoordinates/'+$stateParams.routeId+'.json'
			}).then(function successCallback(response) {
				
				if(response.data.data.results.id_vehicle === undefined)
					return;
				
				response = response.data.data.results;
				
				try{
				
					//Update locations
					
					$scope.vehiclePos.lat = response.lat;
					$scope.vehiclePos.lon = response.lon;

					//Update user POS
				
					$scope.markersList[0].latitude = $scope.curPos.lat;
					$scope.markersList[0].longitude = $scope.curPos.lon;
					
					//Update vehicle POS
					
					$scope.markersList[1].latitude = $scope.vehiclePos.lat;
					$scope.markersList[1].longitude = $scope.vehiclePos.lon;

				}
				catch(Ex){};
				
				//New Timeout
				
				$scope.updateTracker.instance = $timeout($scope.updatePositions, 5000);
				
			});

		}
		
		$scope.init();

    });